/*
 * Decompiled with CFR 0.152.
 */
package fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.verifications;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.resultats.ResultatTriple;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;
import iaik.pkcs.pkcs11.wrapper.CK_MECHANISM;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class VerifierSignatureFichier {
    private static Logger log = Logger.getLogger(VerifierSignatureFichier.class);

    public static Resultat traitementP11(PKCS11 pKCS11, long l, long l2, long l3, FileInputStream fileInputStream, String string) throws ExceptionTraitement {
        try {
            if (pKCS11 != null) {
                if (fileInputStream != null) {
                    boolean bl;
                    byte[] byArray;
                    ResultatTriple resultatTriple;
                    block15: {
                        resultatTriple = new ResultatTriple("V\u00e9rification de la signature d'un fichier avec " + TraitementsUtil.getNomAlgo(l2) + " (Initialisation (C_VerifyInit))", "V\u00e9rification de la signature d'un fichier avec " + TraitementsUtil.getNomAlgo(l2) + " (V\u00e9rification (C_VerifyUpdate))", "V\u00e9rification de la signature d'un fichier (Finalisation (C_VerifyFinal))");
                        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM();
                        cK_MECHANISM.mechanism = l2;
                        byArray = TraitementsUtil.getOctetsSansFormatage(string);
                        bl = false;
                        try {
                            pKCS11.C_VerifyInit(l, cK_MECHANISM, l3);
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            log.info((Object)("Operation echouee : " + TraitementsUtil.retranscritCodeRetour(pKCS11Exception.getErrorCode())));
                            resultatTriple.setCodeRetour(pKCS11Exception.getErrorCode());
                            bl = true;
                            resultatTriple.setCodeRetour2(-1L);
                            resultatTriple.appendOperation2(" NON EXECUTEE!");
                            resultatTriple.setCodeRetour3(-1L);
                            resultatTriple.appendOperation3(" NON EXECUTEE!");
                        }
                        try {
                            if (bl) break block15;
                            int n = 0;
                            boolean bl2 = false;
                            int n2 = 1024;
                            while (!bl2) {
                                n = 0;
                                byte[] byArray2 = new byte[n2];
                                n = fileInputStream.read(byArray2, 0, n2);
                                if (n != -1) {
                                    pKCS11.C_VerifyUpdate(l, byArray2);
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (IOException iOException) {
                            log.error((Object)("Probleme d'entree/sortie\n" + iOException.getMessage()));
                            iOException.printStackTrace();
                            bl = true;
                            resultatTriple.setCodeRetour3(-1L);
                            resultatTriple.appendOperation3(" NON EXECUTEE!");
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            log.info((Object)("Operation echouee : " + TraitementsUtil.retranscritCodeRetour(pKCS11Exception.getErrorCode())));
                            resultatTriple.setCodeRetour2(pKCS11Exception.getErrorCode());
                            bl = true;
                            resultatTriple.setCodeRetour3(-1L);
                            resultatTriple.appendOperation3(" NON EXECUTEE!");
                        }
                    }
                    try {
                        if (!bl) {
                            pKCS11.C_VerifyFinal(l, byArray);
                        }
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        log.info((Object)("Operation echouee : " + TraitementsUtil.retranscritCodeRetour(pKCS11Exception.getErrorCode())));
                        resultatTriple.setCodeRetour3(pKCS11Exception.getErrorCode());
                    }
                    return resultatTriple;
                }
                log.error((Object)"Le fichier est illisible");
                throw new ExceptionTraitement(30, "Le fichier est illisible");
            }
            log.error((Object)"La librairie est nulle");
            throw new ExceptionTraitement(30, "La librairie est nulle");
        }
        catch (Throwable throwable) {
            if (throwable instanceof ExceptionTraitement) {
                throw (ExceptionTraitement)throwable;
            }
            log.error((Object)("Une erreur inattendue est survenue : " + ExceptionProgrammeExemple.getStacktrace(throwable)));
            throw new ExceptionTraitement(30, "Une erreur inattendue est survenue");
        }
    }
}

